/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.apps.launchers.tabbed;

import filenet.vw.apps.launchers.tabbed.VWTabbedLaunchStepPanel;
import filenet.vw.apps.launchers.tabbed.images.VWImageLoader;
import filenet.vw.apps.launchers.tabbed.resources.VWResource;
import filenet.vw.base.VWDebug;
import filenet.vw.base.VWLogger;
import filenet.vw.idm.toolkit.VWIDMBaseFactory;
import filenet.vw.toolkit.utils.IVWSplashWindowListener;
import filenet.vw.toolkit.utils.VWBaseLaunchableApplication;
import filenet.vw.toolkit.utils.VWCommandLineArgs;
import filenet.vw.toolkit.utils.VWHelp;
import filenet.vw.toolkit.utils.VWLoadingWindow;
import filenet.vw.toolkit.utils.VWSessionInfo;
import filenet.vw.toolkit.utils.VWStringUtils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import javax.swing.ImageIcon;

public class VWTabbedLaunchStepApplication
extends VWBaseLaunchableApplication
implements IVWSplashWindowListener {
    private VWTabbedLaunchStepPanel m_tabbedLaunchStepPanel = null;

    public static void main(String[] argv) {
        try {
            VWDebug.init(VWLogger.ERROR);
            VWCommandLineArgs args = new VWCommandLineArgs(argv);
            VWSessionInfo sessionInfo = new VWSessionInfo(null, null, args);
            if (!sessionInfo.verifyLogon(null)) {
                System.exit(1);
            }
            VWTabbedLaunchStepApplication pApp = new VWTabbedLaunchStepApplication();
            pApp.init(sessionInfo);
            VWHelp.init(pApp);
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    public void init(VWSessionInfo sessionInfo) {
        try {
            super.init(sessionInfo);
            String title = VWIDMBaseFactory.instance().getVWString(7).toString();
            this.setTitle(title);
            ImageIcon icon = VWImageLoader.createImageIcon("launcher.gif");
            if (icon != null && icon.getImage() != null) {
                this.setIconImage(icon.getImage());
            }
            if (!this.updatePosition("launchstepproc_location", null)) {
                Dimension dim = VWStringUtils.stringToDimension(VWResource.s_mainWindowDim);
                if (dim == null) {
                    dim = new Dimension(640, 480);
                }
                this.updatePosition(dim.width, dim.height);
            }
            VWLoadingWindow loadingWindow = new VWLoadingWindow((Frame)this, title);
            this.show();
            if (loadingWindow != null) {
                loadingWindow.start(this, 250);
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    public void startProcessing() {
        try {
            this.m_tabbedLaunchStepPanel = new VWTabbedLaunchStepPanel();
            this.getContentPane().setLayout(new BorderLayout(4, 4));
            this.getContentPane().add((Component)this.m_tabbedLaunchStepPanel, "Center");
            this.m_tabbedLaunchStepPanel.init(this.m_sessionInfo);
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    protected boolean destroy() {
        try {
            if (this.m_tabbedLaunchStepPanel != null) {
                this.m_tabbedLaunchStepPanel.destroy();
            }
            return super.destroy();
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
            return false;
        }
    }
}

